package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.data.model.MedicationHistory;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class MedicationHistoryConverter implements Converter<MedicationHistory, MedicationHistoryDTO> {

	@Override
	public MedicationHistoryDTO convert(MedicationHistory source) {
		MedicationHistoryDTO target = new MedicationHistoryDTO();
		
		target.setMedicationId(source.getMedicationId());
		target.setComments(source.getComments());
		target.setReason(source.getReason());
		target.setStartDate(source.getStartDate());
		target.setStrength(source.getStrength());
		target.setPharmacyPhone(source.getPharmacyPhone());
		target.setDosage(source.getDosage());
		target.setFrequency(source.getFrequency());
		target.setCategory(source.getCategory());
		target.setPrescriptionNumber(source.getPrescriptionNumber());
		target.setEndDate(source.getEndDate());
		target.setMedicationName(source.getMedicationName());
		target.setPharmacyName(source.getPharmacyName());
		target.setUserId(source.getUserId());
		
		return target;
	}

	public MedicationHistory convert(MedicationHistoryDTO source) {
		MedicationHistory target = new MedicationHistory();
		
		target.setMedicationId(source.getMedicationId());
		target.setComments(source.getComments());
		target.setReason(source.getReason());
		target.setStartDate(source.getStartDate());
		target.setStrength(source.getStrength());
		target.setPharmacyPhone(source.getPharmacyPhone());
		target.setDosage(source.getDosage());
		target.setFrequency(source.getFrequency());
		target.setCategory(source.getCategory());
		target.setPrescriptionNumber(source.getPrescriptionNumber());
		target.setEndDate(source.getEndDate());
		target.setMedicationName(source.getMedicationName());
		target.setPharmacyName(source.getPharmacyName());
		target.setUserId(source.getUserId());
		
		return target;
	}
}
